## Neue HxViewController State Machine

### States

```
┌─────────┐   viewWillAppear   ┌────────┐   viewDidAppear   ┌─────────┐
│ initial │ ─────────────────► │ loaded │ ────────────────► │ visible │
└─────────┘                    └────────┘                   └─────────┘
                                   │                             │
                                   │                             │ viewWillDisappear
                                   │                             ▼
                                   │                        ┌────────┐
                                   │                        │ hidden │◄──┐
                                   │                        └────────┘   │
                                   │                             │       │ viewDidAppear
                                   │    invalidate()             │       │
                                   ├─────────────────────────────┼───────┘
                                   ▼                             ▼
                              ┌─────────────┐              ┌─────────────┐
                              │ invalidated │◄─────────────│ invalidated │
                              └─────────────┘              └─────────────┘
```

### Vorteile

1. **Klare Zustände** - Jeder Zustand ist explizit (`initial`, `loaded`, `visible`, `hidden`, `invalidated`)
2. **Einfaches Debugging** - Logs zeigen `state=visible` statt `ctr=3`
3. **Sichere Übergänge** - Guards verhindern ungültige Zustandswechsel
4. **Idempotente Invalidierung** - `invalidate()` kann mehrfach aufgerufen werden
5. **Weniger Variablen** - Von 6 Flags/Countern auf 1 State enum reduziert

 